﻿//////////////////////////////////////////////
// BlurComplexEffectInfo.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class Texture ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "BlurType.h"

/// Class ------------------------------------

namespace nkAstraeus
{
	struct BlurComplexEffectInfo final
	{
		// Input texture
		nkGraphics::Texture* _sourceTexture = nullptr ;

		// Settings
		unsigned int _kernelRadius = 5u ;
		BLUR_TYPE _type = BLUR_TYPE::GAUSSIAN ;

		// Flags
		bool _alphaEncodesPlanes = false ;
		bool _preserveAlpha = false ;
	} ;
}